VERSION 5.00
Begin VB.Form frmOfferSpecType 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "#Product specification selection"
   ClientHeight    =   3735
   ClientLeft      =   -15
   ClientTop       =   375
   ClientWidth     =   5475
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3735
   ScaleWidth      =   5475
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   Tag             =   "frmOfferSpecType"
   Visible         =   0   'False
   Begin VB.CommandButton btn_Quit 
      Height          =   612
      Left            =   4755
      Style           =   1  'Graphical
      TabIndex        =   4
      Tag             =   "btn_Quit"
      Top             =   3015
      Width           =   612
   End
   Begin VB.CommandButton btn_Validate 
      Default         =   -1  'True
      Height          =   612
      Left            =   4035
      Style           =   1  'Graphical
      TabIndex        =   3
      Tag             =   "btn_Validate"
      Top             =   3015
      Width           =   612
   End
   Begin VB.Frame fra_ProdSpecType 
      Height          =   2880
      Left            =   60
      TabIndex        =   0
      Tag             =   "fra_SpecType"
      Top             =   60
      Width           =   5310
      Begin VB.Frame fra_OfferType 
         Caption         =   "#Offer type"
         Height          =   750
         Left            =   330
         TabIndex        =   10
         Tag             =   "fra_OfferType"
         Top             =   2040
         Width           =   4875
         Begin VB.OptionButton opt_OfferType 
            Caption         =   "#Budget"
            Height          =   210
            Index           =   0
            Left            =   210
            TabIndex        =   13
            Tag             =   "opt_OfferTypeBudget"
            Top             =   330
            Width           =   1350
         End
         Begin VB.OptionButton opt_OfferType 
            Caption         =   "#Advanced"
            Height          =   210
            Index           =   1
            Left            =   1830
            TabIndex        =   12
            Tag             =   "opt_OfferTypeAdvanced"
            Top             =   330
            Width           =   1185
         End
         Begin VB.OptionButton opt_OfferType 
            Caption         =   "#Final"
            Height          =   210
            Index           =   2
            Left            =   3540
            TabIndex        =   11
            Tag             =   "opt_OfferTypeFinal"
            Top             =   330
            Width           =   1260
         End
      End
      Begin VB.Frame fra_SubProject 
         Caption         =   "#Sub-Project"
         Height          =   1080
         Left            =   345
         TabIndex        =   5
         Tag             =   "fra_SubProject"
         Top             =   960
         Width           =   4860
         Begin VB.OptionButton opt_SubProject 
            Caption         =   "#New"
            Height          =   195
            Index           =   0
            Left            =   165
            TabIndex        =   8
            Tag             =   "opt_SubProjectNew"
            Top             =   270
            Width           =   1650
         End
         Begin VB.OptionButton opt_SubProject 
            Caption         =   "#Existing"
            Height          =   195
            Index           =   1
            Left            =   2490
            TabIndex        =   7
            Tag             =   "opt_SubProjectExisting"
            Top             =   270
            Width           =   2220
         End
         Begin VB.TextBox txt_SubProjectName 
            Height          =   345
            Left            =   90
            MaxLength       =   80
            TabIndex        =   6
            Top             =   585
            Width           =   4635
         End
         Begin Project1.ArmCombobox cbo_SubProject 
            Height          =   345
            Left            =   90
            TabIndex        =   9
            Top             =   585
            Width           =   4650
            _ExtentX        =   8202
            _ExtentY        =   609
         End
      End
      Begin VB.OptionButton opt_ProdSpecType 
         Caption         =   "#Offer"
         Height          =   195
         Index           =   1
         Left            =   300
         TabIndex        =   2
         Tag             =   "opt_SpecTypeOffer"
         Top             =   690
         Width           =   1560
      End
      Begin VB.OptionButton opt_ProdSpecType 
         Caption         =   "#Product specification"
         Height          =   195
         Index           =   0
         Left            =   285
         TabIndex        =   1
         Tag             =   "opt_SpecTypeProduct"
         Top             =   300
         Width           =   2685
      End
   End
End
Attribute VB_Name = "frmOfferSpecType"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit


Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F

Private Const C_ERRORRAISE As Long = 2500
Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SCREEN_NAME As String = "frmOfferSpecType"

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

#If LIVE = 1 Then
  Private mo_Db As Object
  Private mo_FSO As Object
#Else
  Private mo_Db As ARMSYSCOMLib.ArmDb
  Private mo_FSO As FileSystemObject
#End If

Private ms_SPR_Id As String
Private ms_SP_Capkey As String
Private ml_U_Code As Long
Private ms_Language_Code As String
Private mb_InternalInit As Boolean
Private mc_ScreenLabels As Long
Private ml_iConcurrency As Long
Private mo_Tools As DPC_Tools

Public Result As Boolean

Public Property Get SPR_Name() As String
On Error GoTo ErrHandler

  SPR_Name = ""
  If opt_ProdSpecType(1).Value Then
      If opt_SubProject(0).Value Then
          SPR_Name = txt_SubProjectName.Text
      Else
          SPR_Name = cbo_SubProject.Text
      End If
  End If
  Exit Property
ErrHandler:
  Call ErrorHandler("SPR_Name.Get")
End Property

Public Property Get SPR_Id() As String
On Error GoTo ErrHandler

  SPR_Id = ""
  If opt_ProdSpecType(1).Value Then
      If opt_SubProject(0).Value Then
          SPR_Id = ms_SPR_Id
      Else
          SPR_Id = cbo_SubProject.SelectedItem.Key
      End If
  End If
  Exit Property
ErrHandler:
  Call ErrorHandler("SPR_Id.Get")
End Property

Public Property Get ProdSpecType() As eOfferSpecType
On Error GoTo ErrHandler
  
  If opt_ProdSpecType(0).Value Then
    ProdSpecType = eOfferSpecType.stProductSpec
  ElseIf opt_ProdSpecType(1).Value Then
    ProdSpecType = eOfferSpecType.stOfferSpec
  End If
  Exit Property
ErrHandler:
  Call ErrorHandler("ProdSpecType.Get")
End Property

Public Property Get OfferType() As Long
On Error GoTo ErrHandler

  OfferType = -1
  If opt_OfferType(0).Value Then
      OfferType = eOfferType.otBudget
  ElseIf opt_OfferType(1).Value Then
      OfferType = eOfferType.otAdvanced
  ElseIf opt_OfferType(2).Value Then
      OfferType = eOfferType.otFinal
  End If
  Exit Property
ErrHandler:
  Call ErrorHandler("OfferType.Get")
End Property

Public Property Let SP_CapKey(ByVal as_SP_Capkey As String)
  ms_SP_Capkey = as_SP_Capkey
End Property

Public Property Let U_Code(ByVal al_U_Code As Long)
  ml_U_Code = al_U_Code
End Property

Property Let Language_Code(AString As String)
  ms_Language_Code = AString
End Property

Property Get Language_Code() As String
  Language_Code = ms_Language_Code
End Property

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrorHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrorHandler:
  Call ErrorHandler("Tools.Set")
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
  If Not (lo_Db Is Nothing) Then
      Set mo_Db = lo_Db
  End If
End Property

Public Sub Load_A_COM()
On Error GoTo ErrHandler

Dim ls_req As String
  
  If mo_Db Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  If mo_Tools Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  
  Call mo_Tools.Load_A_ComControls(Me.Controls, mo_Db, ms_Language_Code)
  
  btn_Validate.Picture = LoadResPicture(RES_OK, 1)
  btn_Quit.Picture = LoadResPicture(RES_QUIT, 1)
      
  
  ls_req = "exec Cap_Subproject_cbo $SP_Capkey$, $Language_Code$"
  ls_req = Replace(ls_req, "$SP_Capkey$", mo_Tools.SQLStr(ms_SP_Capkey), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  cbo_SubProject.Request = ls_req
  Call cbo_SubProject.Load
  If cbo_SubProject.Count > 0 Then
    Set cbo_SubProject.SelectedItem = cbo_SubProject.ComboItems(1)
    opt_SubProject(1).Value = True
  Else
    opt_SubProject(0).Value = True
  End If
  opt_ProdSpecType(0).Value = True
  opt_OfferType(0).Value = True
  'Screen csts
  mc_ScreenLabels = mo_Tools.LoadLabels(mo_Db, Me.Controls, Me, SCREEN_NAME, ms_Language_Code)
  Call mo_Tools.ChangeCharset(Me.Controls, gl_CodePage, gl_CodePage, Me)
  Result = False
  Exit Sub
ErrHandler:
  Call ErrorHandler("Load_A_COM")
End Sub

Public Sub Unload_A_COM()
On Error GoTo ErrHandler

  Call mo_Tools.Unload_A_ComControls(Me.Controls)
  Call mo_Db.Close(mc_ScreenLabels)
  Set mo_Db = Nothing
  Set mo_FSO = Nothing
  Exit Sub
ErrHandler:
  Call ErrorHandler("Unload_A_COM")
End Sub

Private Sub btn_Quit_Click()
On Error GoTo ErrHandler
    
    Result = False
    Hide
    Exit Sub
ErrHandler:
    Call ErrorMessage("btn_Quit_Click")
End Sub

Private Sub btn_Validate_Click()
On Error GoTo ErrHandler

  Call mo_Tools.LockScreen(Me, True)
  If opt_ProdSpecType(1).Value Then
      If opt_SubProject(0).Value Then
          If Trim(txt_SubProjectName.Text) = "" Then
              Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9701, "#Please, enter mandatory field: $fieldname$", Array("$fieldname$", fra_SubProject.Caption))
              Call mo_Tools.LockScreen(Me, False)
              Exit Sub
          End If
          ms_SPR_Id = RecordAdd(ms_SP_Capkey, SPR_Name, "", ml_U_Code)
      ElseIf opt_SubProject(1).Value Then
          If cbo_SubProject.SelectedItem Is Nothing Then
              Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9701, "#Please, enter mandatory field: $fieldname$", Array("$fieldname$", fra_SubProject.Caption))
              Call mo_Tools.LockScreen(Me, False)
              Exit Sub
          End If
      Else
        Exit Sub
      End If
  End If
  Result = True
  Hide
  Call mo_Tools.LockScreen(Me, False)
  Exit Sub
ErrHandler:
  Call ErrorMessage("btn_Validate_Click")
End Sub

Private Sub opt_ProdSpecType_Click(Index As Integer)
On Error GoTo ErrHandler
    
    fra_OfferType.Visible = (Index = 1)
    fra_SubProject.Visible = (Index = 1)
    Exit Sub
ErrHandler:
    Call ErrorMessage("opt_ProdSpecType_Click")
End Sub

Private Sub opt_SubProject_Click(Index As Integer)
On Error GoTo ErrHandler
    
  Call mo_Tools.LockScreen(Me, True)
  txt_SubProjectName.Visible = (Index = 0)
  cbo_SubProject.Visible = (Index = 1)
  If (Index = 0) And (txt_SubProjectName.Text = "") Then
    txt_SubProjectName.Text = mo_Tools.SelectValue(mo_Db, "SELECT SP_Desc FROM sales_project WHERE SP_Capkey=" & mo_Tools.SQLStr(ms_SP_Capkey))
  End If
  Call mo_Tools.LockScreen(Me, False)
  Exit Sub
ErrHandler:
  Call ErrorMessage("opt_SubProject_Click")
End Sub

Private Function RecordAdd(ByVal as_SP_Capkey As String, ByVal as_SPR_Name As String, ByVal as_SPR_Desc As String, ByVal al_U_Code As String) As String
On Error GoTo ErrHandler

Dim ls_req As String
Dim ls_SPR_Id As String
    
    ls_SPR_Id = mo_Tools.GetNextID(mo_Db, "Cap_Subproject")
    If as_SP_Capkey = "" Then
      Err.Raise 0, "as_SP_Capkey", "Empty SP_Capkey"
    End If
    
    ls_req = "exec Cap_Subproject_ins $SPR_Id$, $SP_Capkey$, $SPR_Name$, $SPR_Desc$, $Z_Creator$ "
    
    ls_req = Replace(ls_req, "$SPR_Id$", mo_Tools.SQLStr(ls_SPR_Id), , , vbTextCompare)
    ls_req = Replace(ls_req, "$SP_Capkey$", mo_Tools.SQLStr(as_SP_Capkey), , , vbTextCompare)
    ls_req = Replace(ls_req, "$SPR_Name$", mo_Tools.SQLStr(as_SPR_Name), , , vbTextCompare)
    ls_req = Replace(ls_req, "$SPR_Desc$", mo_Tools.SQLStr(as_SPR_Desc), , , vbTextCompare)
    ls_req = ReplaceCommonPlaceholders(ls_req)
    Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
    RecordAdd = ls_SPR_Id
    Exit Function
ErrHandler:
    Call ErrorHandler("RecordAdd")
End Function

Private Function ReplaceCommonPlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler

  as_Request = Replace(as_Request, "$Z_Creator$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$U_Code$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$Z_Last_Upd_User$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$Language_Code$", mo_Tools.SQLStr(ms_Language_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$iConcurrency$", mo_Tools.SqlInt(ml_iConcurrency), , , vbTextCompare)
  ReplaceCommonPlaceholders = as_Request
  Exit Function
ErrHandler:
  Call ErrorHandler("ReplaceCommonPlaceholders")
End Function

' display standard error message
Public Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    Dim ls_Message As String
    
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    ls_Message = SCREEN_NAME & " exception. Nr:" & Err.Number & ",Desc: " & ls_errDescription & ",Src:" & ls_ErrSource & "@"
    Call mo_Tools.LogMessage(mo_Db, ml_U_Code, SCREEN_NAME, ls_Message, "E")
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
End Sub

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, Me.Name & "." & as_Fct & SEP1 & Err.Source, Err.Description)
End Sub



